using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hiveAdiz
{
	public class AdizInterstitial
	{

		private static AdizInterstitial instance = null;

		private AdizInterstitial() {}

		~AdizInterstitial() {
			//
		}

		private string adKey = "";

		public static AdizInterstitial Initialize(AdEventHandlers handler) {

			string defaultKey = AdizCallbackManager.defaultInterstitialKey;
			if(string.IsNullOrEmpty(defaultKey)) { 
				AdizLogger.d("adKey is null or empty.");
				return null; 
			}

			instance = new AdizInterstitial();
			instance.internalInit(defaultKey, handler);
			return instance;
		}

		public static AdizInterstitial Initialize(string hiveAdKey, AdEventHandlers handler) {

			if(string.IsNullOrEmpty(hiveAdKey)) { 
				AdizLogger.d("adKey is null or empty.");
				return null; 
			}

			instance = new AdizInterstitial();
			instance.internalInit(hiveAdKey, handler);
			return instance;
		}

		public static AdizInterstitial InitializeWithPlacementId(string placementId, AdEventHandlers handler) {

			// if(string.IsNullOrEmpty(placementId)) { 
			// 	AdizLogger.d("placementId is null or empty.");
			// 	return null; 
			// }

			string hiveAdKey = AdizUnityNativeCaller.Instance.GetHiveAdKeyFromPlacementId(placementId);
			if(string.IsNullOrEmpty(hiveAdKey)) { 
				AdizLogger.d("placementId is invalid");
				return null; 
			}

			instance = new AdizInterstitial();
			instance.internalInit(hiveAdKey, handler);
			return instance;
		}

		private void release() {
			if(AdizCallbackManager.callbackHandler.ContainsKey(adKey)) {
				AdizCallbackManager.callbackHandler.Remove(adKey);	
			}

			instance = null;
		}		
		
	#if UNITY_ANDROID && !UNITY_EDITOR
		
		private AndroidJavaObject currentActivity = null;
		private AndroidJavaObject hiveAdizPlugin = null;

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			AdizLogger.d("AdizInterstitial Init "+hiveAdKey);
			
			AndroidJavaClass jc = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
			currentActivity = jc.GetStatic<AndroidJavaObject>("currentActivity");
			hiveAdizPlugin = new AndroidJavaObject("com.hive.adiz.plugin.AdizUnityInterstitial");

			adKey = hiveAdKey;
			hiveAdizPlugin.Call("initialize", currentActivity, hiveAdKey);
			
			// ArgumentException: An item with the same key has already been added. 에러 회피
			if(AdizCallbackManager.callbackHandler.ContainsKey(hiveAdKey)) {
				AdizCallbackManager.callbackHandler.Remove(hiveAdKey);	
			}
			AdizCallbackManager.callbackHandler.Add(hiveAdKey, handler);
		}

		public void Load() {
			AdizLogger.d("AdizInterstitial Load");
			hiveAdizPlugin.Call("load");
		}

		public void Show() {
			AdizLogger.d("AdizInterstitial Show");
			hiveAdizPlugin.Call("show");
		}

		public void Destroy() {
			hiveAdizPlugin.Call("destroy");
			release();
		}

		public bool IsInitialized() {
			return hiveAdizPlugin.Call<bool>("isInitialized");
		}

		public bool IsLoaded() {
			return hiveAdizPlugin.Call<bool>("isLoaded");
		}

	#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void Adiz_InterstitialInitialize(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_InterstitialLoad(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_InterstitialShow(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_InterstitialDestroy(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern bool Adiz_InterstitialIsInitialized(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern bool Adiz_InterstitialIsLoaded(string hiveAdKey);

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			AdizLogger.d("AdizInterstitial Init "+hiveAdKey);
			adKey = hiveAdKey;
			
			if(AdizCallbackManager.callbackHandler.ContainsKey(hiveAdKey)) {
				AdizCallbackManager.callbackHandler.Remove(hiveAdKey);	
			}
			AdizCallbackManager.callbackHandler.Add(hiveAdKey, handler);

			Adiz_InterstitialInitialize(hiveAdKey);
		}

		public void Load() {
			AdizLogger.d("AdizInterstitial Load");
			Adiz_InterstitialLoad(adKey);
		}

		public void Show() {
			AdizLogger.d("AdizInterstitial Show");
			Adiz_InterstitialShow(adKey);
		}

		public void Destroy() {
			AdizLogger.d("AdizInterstitial Destroy");
			Adiz_InterstitialDestroy(adKey);
			release();
		}

		public bool IsInitialized() {
			return Adiz_InterstitialIsInitialized(adKey);
		}

		public bool IsLoaded() {
			return Adiz_InterstitialIsLoaded(adKey);
		}
	#else

		public void internalInit(string hiveAdKey, AdEventHandlers handler) {
			
		}

		public void Load() {
			
		}		

		public void Show() {
			
		}

		public void Destroy() {
			
		}
		
		public bool IsInitialized() {
			return false;
		}

		public bool IsLoaded() {
			return false;
		}
	#endif
		
	}
}